﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Demo
{
    public partial class Main_Form : Form
    {
        CtrlCard g_CtrlCard = new CtrlCard();
        public Main_Form()
        {
            InitializeComponent();
        }

        private void Main_Form_Load(object sender, EventArgs e)
        {
            this.ActiveControl = this.Title;//设置焦点
            TMOVE_TYPE.Checked = true;
            Int32 i = g_CtrlCard.Init_Board();
            if (i <= 0)
            {
                MessageBox.Show("Control card failed to initialize!");
                if (i == 0)
                {
                    MessageBox.Show("No installation ADT856 card!");
                }
                if (i == -1)
                {
                    MessageBox.Show("Did not install the port driver!");
                }
                if (i == -2)
                {
                    MessageBox.Show("PCI bridge failure!");
                }
            }
            else

                MessageBox.Show("Motion control card can be used!");


        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Int32 log = 0, act = 0, spd = 0;
            Int32 error_x, error_y, error_z, error_w, error_u, error_v;
            //Int32[] a = new Int32[6];

            Int16 i = 0;
            for (i = 1; i <= 6; i++)
            {
                g_CtrlCard.Get_CurrentInf(i, out log, out act, out spd);
                if (i == 1)
                {
                    POS_LOGX.Text = Convert.ToString(log);
                    SpeedX.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_X.Text));
                }
                else if (i == 2)
                {
                    POS_LOGY.Text = Convert.ToString(log);
                    SpeedY.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_Y.Text));
                }
                else if (i == 3)
                {
                    POS_LOGZ.Text = Convert.ToString(log);
                    SpeedZ.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_Z.Text));
                }
                else if (i == 4)
                {
                    POS_LOGW.Text = Convert.ToString(log);
                    SpeedW.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_W.Text));
                }
                else if (i == 5)
                {
                    POS_LOGU.Text = Convert.ToString(log);
                    SpeedU.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_U.Text));
                }
                else if (i == 6)
                {
                    POS_LOGV.Text = Convert.ToString(log);
                    SpeedV.Text = Convert.ToString(spd * Convert.ToInt32(this.Ratio_V.Text));
                }
            }

            //检测限位与停止信号
            for (i = 1; i < 7; i++)
            {
                //检测正限位(XLMT-: 0,YLMT- :8,ZLMT-:16,WLMT- :24)
                if (g_CtrlCard.Read_Input((i - 1) * 8) == 0)
                    ((CheckBox)(this.Controls["LimitN" + i.ToString()])).Checked = true;

                else
                    ((CheckBox)(this.Controls["LimitN" + i.ToString()])).Checked = false;

                //检测负限位(XLMT+ : 1,YLMT+ :9,ZLMT+ :17,WLMT+ :25)
                if (g_CtrlCard.Read_Input((i - 1) * 8 + 1) == 0)
                    ((CheckBox)(this.Controls["LimitP" + i.ToString()])).Checked = true;
                else
                    ((CheckBox)(this.Controls["LimitP" + i.ToString()])).Checked = false;

                //检测stop0(XSTOP0 : 2,YSTOP0 :10,ZSTOP0 :18,WSTOP0 :28)
                if (g_CtrlCard.Read_Input((i - 1) * 8 + 2) == 0)
                    ((CheckBox)(this.Controls["STOP0" + i.ToString()])).Checked = true;
                else
                    ((CheckBox)(this.Controls["STOP0" + i.ToString()])).Checked = false;

                //检测stop1(XSTOP1 : 3,YSTOP1 :11,ZSTOP1 :19,WSTOP1 :27)
                if (g_CtrlCard.Read_Input((i - 1) * 8 + 3) == 0)
                    ((CheckBox)(this.Controls["STOP1" + i.ToString()])).Checked = true;
                else
                    ((CheckBox)(this.Controls["STOP1" + i.ToString()])).Checked = false;
                //检测stop1(XSTOP1 : 4,YSTOP1 :12,ZSTOP1 :20,WSTOP1 :28)
                if (g_CtrlCard.Read_Input((i - 1) * 8 + 4) == 0)
                    ((CheckBox)(this.Controls["STOP2" + i.ToString()])).Checked = true;
                else
                    ((CheckBox)(this.Controls["STOP2" + i.ToString()])).Checked = false;

                /*g_CtrlCard.Get_ErrorInf(i, out a[i-1]);
                STOPDATA_X.Text = Convert.ToString(a[i-1]);
                STOPDATA_Y.Text = Convert.ToString(a[i - 1]);*/

            }
            //
            g_CtrlCard.Get_ErrorInf(1, out error_x);
            STOPDATA_X.Text = Convert.ToString(error_x);
            g_CtrlCard.Get_ErrorInf(2, out error_y);
            STOPDATA_Y.Text = Convert.ToString(error_y);
            g_CtrlCard.Get_ErrorInf(3, out error_z);
            STOPDATA_Z.Text = Convert.ToString(error_z);
            g_CtrlCard.Get_ErrorInf(4, out error_w);
            STOPDATA_W.Text = Convert.ToString(error_w);
            g_CtrlCard.Get_ErrorInf(5, out error_u);
            STOPDATA_U.Text = Convert.ToString(error_u);
            g_CtrlCard.Get_ErrorInf(6, out error_v);
            STOPDATA_V.Text = Convert.ToString(error_v);
            //Console.Write("你好");
        }

        private void BTN_PMOVE_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};

            if (checkBox_X.Checked == true)
            {
                //类型判断
                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Axis_Pmove(1, m_nPulse[0]);//发送脉冲

            }
            if (checkBox_Y.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(2, m_nStartv[1], m_nSpeed[1], m_nAcc[1], m_nDec[1], m_nRatio[1], Class_Data.move_type);
                g_CtrlCard.Axis_Pmove(2, m_nPulse[1]);//发送脉冲

            }
            if (checkBox_Z.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(3, m_nStartv[2], m_nSpeed[2], m_nAcc[2], m_nDec[2], m_nRatio[2], Class_Data.move_type);
                g_CtrlCard.Axis_Pmove(3, m_nPulse[2]);//发送脉冲

            }
            if (checkBox_W.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(4, m_nStartv[3], m_nSpeed[3], m_nAcc[3], m_nDec[3], m_nRatio[3], Class_Data.move_type);
                g_CtrlCard.Axis_Pmove(4, m_nPulse[3]);//发送脉冲

            }
            if (checkBox_U.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(5, m_nStartv[4], m_nSpeed[4], m_nAcc[4], m_nDec[4], m_nRatio[4], Class_Data.move_type);
                g_CtrlCard.Axis_Pmove(5, m_nPulse[4]);//发送脉冲

            }
            if (checkBox_V.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(6, m_nStartv[5], m_nSpeed[5], m_nAcc[5], m_nDec[5], m_nRatio[5], Class_Data.move_type);
                g_CtrlCard.Axis_Pmove(6, m_nPulse[5]);//发送脉冲

            }
            if (!checkBox_X.Checked && !checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                MessageBox.Show("请选轴!");

            }
        }
        public void type()
        {
            if (TMOVE_TYPE.Checked)
            {
                Class_Data.move_type = 0;
            }
            else if (FMOVE_TYPE.Checked)
            {
                Class_Data.move_type = 1;
            }
            else if (SMOVE_TYPE.Checked)
            {
                Class_Data.move_type = 2;
            }

        }

        private void BTN_Stop_Click(object sender, EventArgs e)
        {
            Class_Data.g_WorkStatus = 0;
            for (int i = 1; i <= 6; i++)
            {
              g_CtrlCard.StopRun(i, 0);   //改
            }

            
        }

        private void INPMOVE_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};

            //XY两轴插补
            if (checkBox_X.Checked && checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                //类型判断
                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);

            }
            //ZW两轴插补
            else if (!checkBox_X.Checked && !checkBox_Y.Checked && checkBox_Z.Checked && checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                type();
                g_CtrlCard.Setup_Speed(3, m_nStartv[2], m_nSpeed[2], m_nAcc[2], m_nDec[2], m_nRatio[2], Class_Data.move_type);
                g_CtrlCard.Interp_Move2(2, m_nPulse[2], m_nPulse[2]);//发送脉冲

            }
            //*******************三轴插补********************// 
            else if (checkBox_X.Checked && checkBox_Y.Checked && checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Setup_Speed(3, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度

                g_CtrlCard.Interp_Move3(m_nPulse[0], m_nPulse[1], m_nPulse[2]);

            }
            //*******************四轴插补********************//
            else if (checkBox_X.Checked && checkBox_Y.Checked && checkBox_Z.Checked && checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Setup_Speed(3, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Interp_Move4(m_nPulse[0], m_nPulse[1], m_nPulse[2], m_nPulse[3]);

            }
            //*******************六轴插补********************//
            else if (checkBox_X.Checked && checkBox_Y.Checked && checkBox_Z.Checked && checkBox_W.Checked && checkBox_U.Checked && checkBox_V.Checked)
            {

                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Setup_Speed(3, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Setup_Speed(5, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置
                g_CtrlCard.Interp_Move6(m_nPulse[0], m_nPulse[1], m_nPulse[2], m_nPulse[3], m_nPulse[4], m_nPulse[5]);
            }
            else if (!checkBox_X.Checked && !checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked)
            {
                MessageBox.Show("Please select the interpolation axis!");
            }
            else
            {
                MessageBox.Show("Select the interpolation axis error!");
            }

        }

        private void CLEARPOS_Click(object sender, EventArgs e)
        {
            for (int i = 1; i <= 6; i++)
            {
                g_CtrlCard.Setup_Pos(i, 0, 0);    //逻辑位置设置为零

                g_CtrlCard.Setup_Pos(i, 0, 1);    //实际位置设置为零
            }
        }

        private void CMOVE_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};
            if (!checkBox_X.Checked && !checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
            {
                MessageBox.Show("Please select the drive shaft!");
                return;
            }

            if (checkBox_X.Checked == true)
            {
                //类型判断
                type();
                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);//设置速度
                g_CtrlCard.Axis_Cmove(1, m_nPulse[0] > 0 ? 0 : 1);

            }
            if (checkBox_Y.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(2, m_nStartv[1], m_nSpeed[1], m_nAcc[1], m_nDec[1], m_nRatio[1], Class_Data.move_type);
                g_CtrlCard.Axis_Cmove(2, m_nPulse[1] > 0 ? 0 : 1);

            }
            if (checkBox_Z.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(3, m_nStartv[2], m_nSpeed[2], m_nAcc[2], m_nDec[2], m_nRatio[2], Class_Data.move_type);
                g_CtrlCard.Axis_Cmove(3, m_nPulse[2] > 0 ? 0 : 1);//发送脉冲

            }
            if (checkBox_W.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(4, m_nStartv[3], m_nSpeed[3], m_nAcc[3], m_nDec[3], m_nRatio[3], Class_Data.move_type);
                g_CtrlCard.Axis_Cmove(4, m_nPulse[3] > 0 ? 0 : 1);//发送脉冲

            }
            if (checkBox_U.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(5, m_nStartv[4], m_nSpeed[4], m_nAcc[4], m_nDec[4], m_nRatio[4], Class_Data.move_type);
                g_CtrlCard.Axis_Cmove(5, m_nPulse[4] > 0 ? 0 : 1);//发送脉冲

            }
            if (checkBox_V.Checked == true)
            {
                type();
                g_CtrlCard.Setup_Speed(6, m_nStartv[5], m_nSpeed[5], m_nAcc[5], m_nDec[5], m_nRatio[5], Class_Data.move_type);
                g_CtrlCard.Axis_Cmove(6, m_nPulse[5] > 0 ? 0 : 1);//发送脉冲

            }
        }

        private void ARC_INP_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};

            Int32 value = 0;
            Double tmpvalue;
            type();
            if ((Class_Data.move_type == 0) || (Class_Data.move_type == 1))
            {
                if ((checkBox_X.Checked) && (checkBox_Y.Checked) && (!checkBox_Z.Checked) && (!checkBox_W.Checked))
                {
                    g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);
                    if (m_nStartv[0] < m_nSpeed[0]) //加减速运动
                    {
                        //***************************************//
                        //  中间为0的参数值意思为对称加减速       //
                        //   在最后参数1的对应参数值为手动减速    //
                        //****************************************//
                        g_CtrlCard.Set_DecMode(1, 0, 1);

                        //X-Y轴距离脉冲数据类型定义，在这里数据类型定义出错就会出现异常
                        tmpvalue = (Double)(m_nPulse[0]) * (Double)(m_nPulse[0]) + (Double)(m_nPulse[1]) * (Double)(m_nPulse[1]);

                        value = (Int32)(Math.Sqrt(tmpvalue) / 1.414) * 8;

                        g_CtrlCard.Set_DecPos(1, value, m_nStartv[0], m_nSpeed[0], m_nAcc[0]);
                    }
                    //当选取X-Y轴的时候进行顺时针插补
                    g_CtrlCard.Interp_Arc(1, 0, 0, m_nPulse[0], m_nPulse[1]);
                }
                else if ((!checkBox_X.Checked) && (!checkBox_Y.Checked) && (checkBox_Z.Checked) && (checkBox_W.Checked))
                {
                    g_CtrlCard.Setup_Speed(3, m_nStartv[2], m_nSpeed[2], m_nAcc[2], m_nDec[2], m_nRatio[2], Class_Data.move_type);
                    if (m_nStartv[2] < m_nSpeed[2]) //加减速运动
                    {
                        //***************************************//
                        //  中间为0的参数值意思为对称加减速       //
                        //   在最后参数1的对应参数值为手动减速    //
                        //****************************************//
                        g_CtrlCard.Set_DecMode(3, 0, 1);

                        //Z-W轴距离脉冲数据类型定义，在这里数据类型定义出错就会出现异常
                        tmpvalue = (Double)(m_nPulse[2]) * (Double)(m_nPulse[2]) + (Double)(m_nPulse[3]) * (Double)(m_nPulse[3]);

                        value = (Int32)(Math.Sqrt(tmpvalue) / 1.414) * 8;

                        g_CtrlCard.Set_DecPos(3, value, m_nStartv[2], m_nSpeed[2], m_nAcc[2]);
                    }
                    //当选取Z-W轴的时候进行逆时针圆弧插补
                    g_CtrlCard.Interp_Arc(2, m_nPulse[2] * 2, m_nPulse[3] * 2, m_nPulse[2], m_nPulse[3]);
                }
                else
                {
                    MessageBox.Show("Please select the X-Y, or Z-W-axis!");
                }


            }
            else
            {
                MessageBox.Show("Can not select the S-curve acceleration and deceleration type!");
            }
        }

        private void CONTINUE_INP_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};
            Int32 no;
            Int32 status1 = -1;
            Int32 status2 = -1;
            type();
            if ((Class_Data.move_type == 0) || (Class_Data.move_type == 1))
            {
                //在这里只对X-Y轴进行连续插补实现
                if (checkBox_X.Checked && checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
                {
                    no = 1;
                }
                else
                {
                    MessageBox.Show("Demonstration here only on the XY axis, select the X-Y-axis!");

                    return;
                }

                Class_Data.g_WorkStatus = 1;

                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);


                //加减速运动
                if (m_nStartv[0] <= m_nSpeed[0])
                {
                    //后面的参数1值意为手动减速，因为只能用手动减速
                    g_CtrlCard.Set_DecMode(1, 0, 1);

                    g_CtrlCard.Set_DecPos(1, m_nPulse[0], m_nStartv[0], m_nSpeed[0], m_nAcc[0]);
                }

                //插补减速禁止响应函数   
                g_CtrlCard.ForbidDec(no);

                //---------------第一段-------------------
               g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);

                while (true)
                {
                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0 || Class_Data.g_WorkStatus == 0)//
                    {
                        //System.Threading.Thread.Sleep(100);
                        goto err;
                    }
                        
                    //status2:   0:不允许写入    1：允许写入
                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0)
                    {
                        break;
                       
                    }
                    Application.DoEvents();
                    //Application->ProcessMessages();   

                }
               
                //----------------第二段------------------
                
                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);

                while (true)
                {
                  
                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if ( status1 != 0||Class_Data.g_WorkStatus == 0)//
                    {
                        goto err;

                    } 
                    //status2:   0:不允许写入    1：允许写入
                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0)
                        break;
                    Application.DoEvents();

                }
               
                //Application.DoEvents();
                //-----------------第三段-----------------
                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);
                while (true)
                {
                    // DoEvent();
                    //Application.ProcessMessages; 
                   
                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0 || Class_Data.g_WorkStatus == 0)
                    {
                        System.Threading.Thread.Sleep(1); goto err;
                    }
                       //

                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0) break;

                    Application.DoEvents();
                    //System.

                }

                //-----------------最后一段-----------------
               g_CtrlCard.AllowDec(no);//插补减速允许响应函数				


                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);
                while (true)
                {
                    

                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0 || Class_Data.g_WorkStatus == 0) //g_WorkStatus为停止的时候就报错
                    {
                        System.Threading.Thread.Sleep(1); goto err;
                    }

                    g_CtrlCard.Get_Status(no, out status2, 1);
                    if (status2 == 0) break;

                    Application.DoEvents();
                    
                }

                Class_Data.g_WorkStatus = 0;

                return;

            err:
                MessageBox.Show("Error!");
                return;
            }
            else
            {
                MessageBox.Show("Can not select the S-curve acceleration and deceleration type !");
            }
        }

        private void BASEPARA_Click(object sender, EventArgs e)
        {
            Param_Set Para = new Param_Set();
            Para.Show();
        }

        private void IOTEST_Click(object sender, EventArgs e)
        {
            IO_Test Test = new IO_Test();
            Test.Show();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            int[] m_nStartv = { Convert.ToInt32(this.StartV_X.Text),
                                Convert.ToInt32(this.StartV_Y.Text),
                                Convert.ToInt32(this.StartV_Z.Text),
                                Convert.ToInt32(this.StartV_W.Text),
                                Convert.ToInt32(this.StartV_U.Text),
                                Convert.ToInt32(this.StartV_V.Text) };

            int[] m_nSpeed = { Convert.ToInt32(this.Speed_X.Text),
                               Convert.ToInt32(this.Speed_Y.Text),
                               Convert.ToInt32(this.Speed_Z.Text),
                               Convert.ToInt32(this.Speed_W.Text),
                               Convert.ToInt32(this.Speed_U.Text),
                               Convert.ToInt32(this.Speed_V.Text)};

            int[] m_nAcc =  { Convert.ToInt32(this.Acc_X.Text),
                              Convert.ToInt32(this.Acc_Y.Text),
                              Convert.ToInt32(this.Acc_Z.Text),
                              Convert.ToInt32(this.Acc_W.Text), 
                              Convert.ToInt32(this.Acc_U.Text),
                              Convert.ToInt32(this.Acc_V.Text)};

            int[] m_nDec =  { Convert.ToInt32(this.Dec_X.Text),
                              Convert.ToInt32(this.Dec_Y.Text),
                              Convert.ToInt32(this.Dec_Z.Text),
                              Convert.ToInt32(this.Dec_W.Text),
                              Convert.ToInt32(this.Dec_U.Text),
                              Convert.ToInt32(this.Dec_V.Text) };

            int[] m_nRatio =  { Convert.ToInt32(this.Ratio_X.Text),
                              Convert.ToInt32(this.Ratio_Y.Text),
                              Convert.ToInt32(this.Ratio_Z.Text),
                              Convert.ToInt32(this.Ratio_W.Text),
                              Convert.ToInt32(this.Ratio_U.Text),
                              Convert.ToInt32(this.Ratio_V.Text)};

            int[] m_nPulse = { Convert.ToInt32(this.PulseX.Text),
                               Convert.ToInt32(this.PulseY.Text),
                               Convert.ToInt32(this.PulseZ.Text),
                               Convert.ToInt32(this.PulseW.Text),
                               Convert.ToInt32(this.PulseU.Text),
                               Convert.ToInt32(this.PulseV.Text)};
            Int32 no;
            Int32 status1 = -1;
            Int32 status2 = -1;
            type();
            if ((Class_Data.move_type == 0) || (Class_Data.move_type == 1))
            {
                //在这里只对X-Y轴进行连续插补实现
                if (checkBox_X.Checked && checkBox_Y.Checked && !checkBox_Z.Checked && !checkBox_W.Checked && !checkBox_U.Checked && !checkBox_V.Checked)
                {
                    no = 1;
                }
                else
                {
                    MessageBox.Show("Demonstration here only on the XY axis, select the X-Y-axis!");

                    return;
                }

                Class_Data.g_WorkStatus = 1;

                g_CtrlCard.Setup_Speed(1, m_nStartv[0], m_nSpeed[0], m_nAcc[0], m_nDec[0], m_nRatio[0], Class_Data.move_type);


                //加减速运动
                if (m_nStartv[0] <= m_nSpeed[0])
                {
                    //后面的参数1值意为手动减速，因为只能用手动减速
                    g_CtrlCard.Set_DecMode(1, 0, 1);

                    g_CtrlCard.Set_DecPos(1, m_nPulse[0], m_nStartv[0], m_nSpeed[0], m_nAcc[0]);
                }

                //插补减速禁止响应函数   
                g_CtrlCard.ForbidDec(no);

                //---------------第一段-------------------
                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);

                while (true)
                {

                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0)//|| Class_Data.g_WorkStatus == 0
                    {
                        //System.Threading.Thread.Sleep(100);
                        goto err;
                    }

                    //status2:   0:不允许写入    1：允许写入
                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0) break;
                    Application.DoEvents();

                }

                //----------------第二段------------------
                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);

                while (true)
                {


                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0)//|| Class_Data.g_WorkStatus == 0
                    {
                        goto err;

                    }
                    //status2:   0:不允许写入    1：允许写入
                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0)
                        break;

                    Application.DoEvents();

                }

                //-----------------第三段-----------------
                /*g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);
                while (true)
                {
                    // DoEvent();
                    //Application.ProcessMessages; 
                   
                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0 || Class_Data.g_WorkStatus == 0)
                    {
                        System.Threading.Thread.Sleep(1); goto err;
                    }
                       //

                    g_CtrlCard.Get_AllowInpStatus(no, out status2);

                    if (status2 != 0) break;

                    Application.DoEvents();
                    //System.

                }

                //-----------------最后一段-----------------
               g_CtrlCard.AllowDec(no);//插补减速允许响应函数				


                g_CtrlCard.Interp_Move2(1, m_nPulse[0], m_nPulse[1]);
                while (true)
                {
                    

                    g_CtrlCard.Get_ErrorInf(1, out status1);

                    if (status1 != 0 || Class_Data.g_WorkStatus == 0) //g_WorkStatus为停止的时候就报错
                    {
                        System.Threading.Thread.Sleep(1); goto err;
                    }

                    g_CtrlCard.Get_Status(no, out status2, 1);
                    if (status2 == 0) break;

                    Application.DoEvents();
                    
                }*/

                Class_Data.g_WorkStatus = 0;

                return;

            err:
                MessageBox.Show("Error!");
                return;
            }
            else
            {
                MessageBox.Show("Can not select the S-curve acceleration and deceleration type !");
            }
        }

        private void button1_Click_1(object sender, EventArgs e)
        {
            
        }


    }
}